/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.content.trains.schedule.destination;

import com.google.common.collect.ImmutableList;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.Create;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.graph.DiscoveredPath;
import com.simibubi.create.content.trains.graph.EdgePointType;
import com.simibubi.create.content.trains.schedule.ScheduleRuntime;
import com.simibubi.create.content.trains.schedule.destination.TextScheduleInstruction;
import com.simibubi.create.content.trains.station.GlobalStation;
import com.simibubi.create.foundation.utility.CreateLang;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.createmod.catnip.data.Glob;
import net.createmod.catnip.data.Pair;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_342;
import org.apache.commons.lang3.StringUtils;

public class DestinationInstruction
extends TextScheduleInstruction {
    @Override
    public Pair<class_1799, class_2561> getSummary() {
        return Pair.of((Object)AllBlocks.TRACK_STATION.asStack(), (Object)class_2561.method_43470((String)this.getLabelText()));
    }

    @Override
    public boolean supportsConditions() {
        return true;
    }

    @Override
    public class_2960 getId() {
        return Create.asResource("destination");
    }

    @Override
    public class_1799 getSecondLineIcon() {
        return AllBlocks.TRACK_STATION.asStack();
    }

    public String getFilter() {
        return this.getLabelText();
    }

    public String getFilterForRegex() {
        return Glob.toRegexPattern((String)this.getFilter(), (String)"");
    }

    @Override
    public List<class_2561> getSecondLineTooltip(int slot) {
        return ImmutableList.of((Object)CreateLang.translateDirect("schedule.instruction.filter_edit_box", new Object[0]), (Object)CreateLang.translateDirect("schedule.instruction.filter_edit_box_1", new Object[0]).method_27692(class_124.field_1080), (Object)CreateLang.translateDirect("schedule.instruction.filter_edit_box_2", new Object[0]).method_27692(class_124.field_1063), (Object)CreateLang.translateDirect("schedule.instruction.filter_edit_box_3", new Object[0]).method_27692(class_124.field_1063));
    }

    @Override
    @Environment(value=EnvType.CLIENT)
    protected void modifyEditBox(class_342 box) {
        box.method_1890(s -> StringUtils.countMatches((CharSequence)s, (char)'*') <= 3);
    }

    @Override
    @Nullable
    public DiscoveredPath start(ScheduleRuntime runtime, class_1937 level) {
        String regex = this.getFilterForRegex();
        boolean anyMatch = false;
        ArrayList<GlobalStation> validStations = new ArrayList<GlobalStation>();
        Train train = runtime.train;
        if (!train.hasForwardConductor() && !train.hasBackwardConductor()) {
            train.status.missingConductor();
            runtime.startCooldown();
            return null;
        }
        for (GlobalStation globalStation : train.graph.getPoints(EdgePointType.STATION)) {
            if (!globalStation.name.matches(regex)) continue;
            anyMatch = true;
            validStations.add(globalStation);
        }
        DiscoveredPath best = train.navigation.findPathTo(validStations, Double.MAX_VALUE);
        if (best == null) {
            if (anyMatch) {
                train.status.failedNavigation();
            } else {
                train.status.failedNavigationNoTarget(this.getFilter());
            }
            runtime.startCooldown();
            return null;
        }
        return best;
    }
}

